<?php

declare(strict_types=1);

namespace Erlage\Photogram\Requests\Misc;

use Erlage\Photogram\State;
use Erlage\Photogram\Settings;
use Erlage\Photogram\Constants\ServerConstants;
use Erlage\Photogram\Pattern\ExceptionalRequests;
use Erlage\Photogram\Data\Dtos\Common\ApiCompatibilityDTO;

final class MiscContent extends ExceptionalRequests
{
    /*
    |--------------------------------------------------------------------------
    | settings
    |--------------------------------------------------------------------------
    */

    public static function settings(): void
    {
        self::process(function ()
        {
            /*
            |--------------------------------------------------------------------------
            | prepare maps
            |--------------------------------------------------------------------------
            */

            self::$response -> setContent('', Settings::getPublicSettings());
        });
    }

    public static function compatibility(): void
    {
        self::process(function ()
        {
            /*
            |--------------------------------------------------------------------------
            | check client api version support
            |--------------------------------------------------------------------------
            */

            if (\version_compare(State::getApiVersion(), Settings::getString(ServerConstants::SS_TEXT_MINIMUM_API_VERSION), '>='))
            {
                $compatibilityDTO = (new ApiCompatibilityDTO())
                    -> setStatus(ApiCompatibilityDTO::STATUS_SUPPORTED)
                    -> setMessage('')
                    -> setIosUpdateUrl('')
                    -> setAndroidUpdateUrl('');
            }
            else
            {
                $compatibilityDTO = (new ApiCompatibilityDTO())
                    -> setStatus(ApiCompatibilityDTO::STATUS_REQUIRES_UPDATE)
                    -> setMessage(Settings::getString(ServerConstants::SS_TEXT_API_UPDATE_MESSAGE))
                    -> setIosUpdateUrl(Settings::getString(ServerConstants::SS_TEXT_API_IOS_UPDATE_URL))
                    -> setAndroidUpdateUrl(Settings::getString(ServerConstants::SS_TEXT_API_ANDROID_UPDATE_URL));
            }

            /*
            |--------------------------------------------------------------------------
            | add to response
            |--------------------------------------------------------------------------
            */

            self::$response -> setContent(ApiCompatibilityDTO::DTO_NAME, array($compatibilityDTO -> jsonSerialize()));
        });
    }
}
